Imports System.Drawing
Imports System.WinForms
Imports System.Runtime.InteropServices
Imports System.ComponentModel


'************************************************
'MODULE SECTION
'************************************************
Public Module mod1
    'declare delegate object
    Delegate Function HookCallback(ByVal Code As Integer, ByVal wParam As Integer, _
      ByVal lParam As Integer) As Integer

    'declare API's
    Public Declare Function SetWindowsHookEx Lib "user32" Alias "SetWindowsHookExA" _
      (ByVal HookID As Integer, ByVal lpfn As HookCallback, ByVal hModule As Integer, _
      ByVal ThreadId As Integer) As Integer
    Public Declare Function UnhookWindowsHookEx Lib "user32" Alias "UnhookWindowsHookEx" _
      (ByVal hHook As Integer) As Integer
    Public Declare Function CallNextHookEx Lib "user32" Alias "CallNextHookEx" _
      (ByVal hHook As Integer, ByVal Code As Integer, ByVal wParam As Integer, _
      ByVal lParam As Integer) As Integer
    Public Declare Sub CopyMemory Lib "kernel32" Alias "RtlMoveMemory" _
      (ByRef Destination As mod1.MOUSEHOOKSTRUCT, ByVal Source As Integer, _
      ByVal Length As Integer)

    'Global constants
    Public Const WH_MOUSE As Integer = 7

    Structure POINTAPI
        Public x As Integer
        Public y As Integer
    End Structure

    Structure MOUSEHOOKSTRUCT
        Public pt As POINTAPI
        Public hwnd As Integer
        Public wHitTestCode As Integer
        Public dwExtraInfo As Integer
    End Structure

    Private m_hHook As Integer

    'Property to access hook handle
    Property hHook() As Integer
        Set
            If m_hHook <> 0 And Value <> 0 Then
                'Don't overwrite the handle
                '   Unless it is being reset to 0
            Else
                m_hHook = Value
            End If
        End Set

        Get
            hHook = m_hHook
        End Get
    End Property
End Module


'************************************************
'FORM SECTION
'************************************************
Public Class frmHook
    Inherits System.WinForms.Form

    'declare nested class var
    Public hk As Hook

    'declare delegate object
    Public cb As HookCallback
    
    
    'START HERE - default ctor for Form1 class
    Public Sub New()
        MyBase.New()
        InitializeComponent()
        'frmHook = Me
        
        'instantiate a new nested Hook class passing in a reference to this form
        hk = New Hook(Me)
        
        'instantiate a new delegate object pointing to the HookProc function
        '   in the nested class
        cb = New HookCallback(AddressOf hk.HookProc)
    End Sub
    
    
    '************************************************
    'NESTED CLASS-containing the callback HookProc
    '************************************************
    Public Class Hook
        'reference back to the form
        Private TheWin As frmHook
        
        'ctor - used to get a reference to the main window
        '       in order to write info to the textbox1 text box
        Public Sub New(ByVal MainWnd As frmHook)
            TheWin = MainWnd
        End Sub
        
        'HOOK PROC
        Public Function HookProc(ByVal Code As Integer, ByVal wParam As Integer, _
          ByVal lParam As Integer) As Integer
            Dim Dest As New mod1.MOUSEHOOKSTRUCT()
            
            copymemory(Dest, lParam, sizeof(Dest))
            TheWin.PrintTxt(Dest.hwnd & " : " & Dest.pt.x & " : " & Dest.pt.y & _
              " : " & Dest.wHitTestCode)
            
            HookProc = CallNextHookEx(hHook, Code, wParam, lParam)
        End Function
    End Class
    
    
    'used by Form1 to add text to the textbox1 text box, called by HookProc
    Public Sub PrintTxt(ByVal ip As String)
        textBox1.Text = TextBox1.Text & ip & chr(13) & chr(10)
    End Sub
    
    
    '************************************************
    'REGULAR WINDOWS .NET STUFF
    '************************************************
#Region " Windows Form Designer generated code "
    
    'Required by the Windows Form Designer
    Private components As System.ComponentModel.Container
    Private WithEvents Button2 As System.WinForms.Button
    Private WithEvents Button1 As System.WinForms.Button
    Private WithEvents TextBox1 As System.WinForms.TextBox
    
    Dim WithEvents Hook_Try2 As System.WinForms.Form
    
    'NOTE: The following procedure is required by the Windows Form Designer
    'It can be modified using the Windows Form Designer.
    'Do not modify it using the code editor.
    Private Sub InitializeComponent()
        Me.components = New System.ComponentModel.Container()
        Me.Button1 = New System.WinForms.Button()
        Me.Button2 = New System.WinForms.Button()
        Me.TextBox1 = New System.WinForms.TextBox()
        
        '@design Me.TrayHeight = 0
        '@design Me.TrayLargeIcon = False
        '@design Me.TrayAutoArrange = True
        Button1.Location = New System.Drawing.Point(8, 8)
        Button1.Size = New System.Drawing.Size(75, 23)
        Button1.TabIndex = 1
        Button1.Text = "Hook"
        
        Button2.Location = New System.Drawing.Point(8, 40)
        Button2.Size = New System.Drawing.Size(75, 23)
        Button2.TabIndex = 2
        Button2.Text = "UnHook"
        
        TextBox1.Location = New System.Drawing.Point(88, 0)
        TextBox1.Multiline = True
        TextBox1.ScrollBars = System.WinForms.ScrollBars.Both
        TextBox1.TabIndex = 0
        TextBox1.Size = New System.Drawing.Size(448, 620)
        
        Me.Text = "VB.NET Hooking Example"
        Me.AutoScaleBaseSize = New System.Drawing.Size(5, 13)
        Me.ClientSize = New System.Drawing.Size(536, 617)
        
        Me.Controls.Add(Button2)
        Me.Controls.Add(Button1)
        Me.Controls.Add(TextBox1)
    End Sub
    
#End Region
    
    'Form overrides dispose to clean up the component list.
    Public Overrides Sub Dispose()
        MyBase.Dispose()
        components.Dispose()
    End Sub
    
    '************************************************
    'EVENT HANDLERS FOR BUTTON CONTROLS
    '************************************************
    Protected Sub Button1_Click(ByVal sender As Object, ByVal e As System.EventArgs)
        'Install hook
        hHook = SetWindowsHookEx(WH_MOUSE, cb, 0, appdomain.GetCurrentThreadId)
        msgbox(hHook)
    End Sub
    Protected Sub Button2_Click(ByVal sender As Object, ByVal e As System.EventArgs)
        'Release hook
        msgbox(UnhookWindowsHookEx(hHook))
        hHook = 0
    End Sub
End Class
